EESchema Schematic File Version 2
LIBS:power
LIBS:device
LIBS:transistors
LIBS:conn
LIBS:linear
LIBS:regul
LIBS:74xx
LIBS:cmos4000
LIBS:adc-dac
LIBS:memory
LIBS:xilinx
LIBS:special
LIBS:microcontrollers
LIBS:dsp
LIBS:microchip
LIBS:analog_switches
LIBS:motorola
LIBS:texas
LIBS:intel
LIBS:audio
LIBS:interface
LIBS:digital-audio
LIBS:philips
LIBS:display
LIBS:cypress
LIBS:siliconi
LIBS:opto
LIBS:atmel
LIBS:contrib
LIBS:valves
LIBS:transceiver
LIBS:bid_tvs
LIBS:TPS62160
LIBS:tvs
LIBS:power_flag
LIBS:cdsot23-sm712
LIBS:boosterpack
LIBS:commboard-cache
EELAYER 27 0
EELAYER END
$Descr A4 11693 8268
encoding utf-8
Sheet 1 1
Title "ToLHnet communication board"
Date "4 may 2017"
Rev "2"
Comp "Università Politecnica delle Marche"
Comment1 "Giorgio Biagetti & Luca Buccolini (student)"
Comment2 ""
Comment3 ""
Comment4 ""
$EndDescr
$Comp
L RFM23B U4
U 1 1 58FE2F23
P 9850 1700
F 0 "U4" H 9900 1050 50  0000 C CNN
F 1 "RFM23B" H 9900 2050 50  0000 C CNN
F 2 "RFM23B" H 9900 1700 60  0001 C CNN
F 3 "http://www.hoperf.com/upload/rf/RFM22B_23B.pdf" H 9900 1700 60  0001 C CNN
F 4 "HopeRF" H 9850 1700 60  0001 C CNN "Manufacturer"
F 5 "RFM23B-433-S2" H 9850 1700 60  0001 C CNN "P/N"
F 6 "Ideetron" H 9850 1700 60  0001 C CNN "Supplier"
	1    9850 1700
	1    0    0    -1  
$EndComp
Text Notes 9640 710  0    60   ~ 0
RF module
$Comp
L +3.3V #PWR01
U 1 1 58FE2F45
P 9350 800
F 0 "#PWR01" H 9350 760 30  0001 C CNN
F 1 "+3.3V" H 9350 910 30  0000 C CNN
F 2 "~" H 9350 800 60  0000 C CNN
F 3 "~" H 9350 800 60  0000 C CNN
	1    9350 800 
	1    0    0    -1  
$EndComp
$Comp
L +3.3V #PWR02
U 1 1 58FE2F4B
P 10450 800
F 0 "#PWR02" H 10450 760 30  0001 C CNN
F 1 "+3.3V" H 10450 910 30  0000 C CNN
F 2 "~" H 10450 800 60  0000 C CNN
F 3 "~" H 10450 800 60  0000 C CNN
	1    10450 800 
	1    0    0    -1  
$EndComp
$Comp
L R R18
U 1 1 58FE2F56
P 10450 1100
F 0 "R18" V 10550 1200 40  0000 C CNN
F 1 "100k" V 10457 1101 40  0000 C CNN
F 2 "SM0603" V 10380 1100 30  0001 C CNN
F 3 "" H 10450 1100 30  0001 C CNN
F 4 "Panasonic" H 10450 1100 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ104V" H 10450 1100 60  0001 C CNN "P/N"
	1    10450 1100
	-1   0    0    1   
$EndComp
Wire Wire Line
	10300 1500 10400 1500
Wire Wire Line
	10400 1500 10400 2400
Wire Wire Line
	10300 2200 10400 2200
Connection ~ 10400 2200
$Comp
L GND #PWR03
U 1 1 58FE300E
P 10400 2400
F 0 "#PWR03" H 10400 2400 30  0001 C CNN
F 1 "GND" H 10400 2330 30  0001 C CNN
F 2 "" H 10400 2400 60  0000 C CNN
F 3 "" H 10400 2400 60  0000 C CNN
	1    10400 2400
	1    0    0    -1  
$EndComp
Wire Wire Line
	10500 2100 10300 2100
Wire Wire Line
	10300 2000 10500 2000
Wire Wire Line
	10500 1900 10300 1900
Wire Wire Line
	10300 1800 10500 1800
Wire Wire Line
	10500 1700 10300 1700
Wire Wire Line
	10300 1600 10500 1600
Wire Wire Line
	9450 2200 9250 2200
Wire Wire Line
	9250 2100 9450 2100
Wire Wire Line
	9450 2000 9250 2000
Wire Wire Line
	9350 800  9350 1900
Wire Wire Line
	9350 1900 9450 1900
Wire Wire Line
	10450 800  10450 850 
Wire Wire Line
	9450 1600 9150 1600
Wire Wire Line
	9450 1500 9150 1500
$Comp
L BNC P4
U 1 1 58FE3120
P 9000 1500
F 0 "P4" H 9010 1620 60  0000 C CNN
F 1 "SMA" V 9110 1440 40  0000 C CNN
F 2 "SMA" H 9000 1500 60  0001 C CNN
F 3 "~" H 9000 1500 60  0000 C CNN
F 4 "TE Connectivity" H 9000 1500 60  0001 C CNN "Manufacturer"
F 5 "5-1814400-1" H 9000 1500 60  0001 C CNN "P/N"
	1    9000 1500
	-1   0    0    -1  
$EndComp
Wire Wire Line
	9150 1600 9150 1700
Wire Wire Line
	9150 1700 8750 1700
Wire Wire Line
	9000 1700 9000 1750
$Comp
L GND #PWR04
U 1 1 58FE3157
P 9000 1750
F 0 "#PWR04" H 9000 1750 30  0001 C CNN
F 1 "GND" H 9000 1680 30  0001 C CNN
F 2 "" H 9000 1750 60  0000 C CNN
F 3 "" H 9000 1750 60  0000 C CNN
	1    9000 1750
	1    0    0    -1  
$EndComp
Wire Wire Line
	10450 1350 10450 1600
Connection ~ 10450 1600
Wire Wire Line
	8750 1700 8750 1650
Connection ~ 9000 1700
$Comp
L RFSHIELD S4
U 1 1 58FE46C8
P 8750 1650
F 0 "S4" H 8750 1950 40  0000 C CNN
F 1 "RFSHIELD" H 8750 1900 30  0000 C CNN
F 2 "RFshield" H 8750 1650 60  0001 C CNN
F 3 "~" H 8750 1650 60  0000 C CNN
F 4 "Laird Technologies" H 8750 1650 60  0001 C CNN "Manufacturer"
F 5 "BMIS-203-F + BMIS-203-C" H 8750 1650 60  0001 C CNN "P/N"
	1    8750 1650
	1    0    0    -1  
$EndComp
$Comp
L INDUCTOR_SMALL L1
U 1 1 59009AB7
P 4800 6150
F 0 "L1" H 4800 6250 50  0000 C CNN
F 1 "2u2" H 4800 6100 50  0000 C CNN
F 2 "~" H 4800 6150 60  0000 C CNN
F 3 "http://www.farnell.com/datasheets/1734585.pdf" H 4800 6150 60  0001 C CNN
F 4 "Taiyo Yuden" H 4800 6150 60  0001 C CNN "Manufacturer"
F 5 "NR3015T2R2M" H 4800 6150 60  0001 C CNN "P/N"
	1    4800 6150
	1    0    0    -1  
$EndComp
$Comp
L R R4
U 1 1 59009AC2
P 5100 6550
F 0 "R4" V 5200 6650 40  0000 C CNN
F 1 "300k" V 5107 6551 40  0000 C CNN
F 2 "SM0603" V 5030 6550 30  0001 C CNN
F 3 "http://www.farnell.com/datasheets/1697337.pdf" H 5100 6550 30  0001 C CNN
F 4 "Panasonic" H 5100 6550 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3EKF3003V" H 5100 6550 60  0001 C CNN "P/N"
	1    5100 6550
	-1   0    0    1   
$EndComp
$Comp
L R R5
U 1 1 59009ACD
P 5100 7150
F 0 "R5" V 5200 7250 40  0000 C CNN
F 1 "95k3" V 5107 7151 40  0000 C CNN
F 2 "SM0603" V 5030 7150 30  0001 C CNN
F 3 "" H 5100 7150 30  0001 C CNN
F 4 "Panasonic" H 5100 7150 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3EKF9532V" H 5100 7150 60  0001 C CNN "P/N"
	1    5100 7150
	-1   0    0    1   
$EndComp
$Comp
L TPS62160 U1
U 1 1 59009AD8
P 3550 6200
F 0 "U1" H 3600 6100 50  0000 C CNN
F 1 "TPS62160" H 3600 6300 50  0000 C CNN
F 2 "MODULE" H 3550 6200 50  0001 C CNN
F 3 "DOCUMENTATION" H 3550 6200 50  0001 C CNN
F 4 "Texas Instruments" H 3550 6200 60  0001 C CNN "Manufacturer"
F 5 "TPS62160DGKR" H 3550 6200 60  0001 C CNN "P/N"
	1    3550 6200
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR05
U 1 1 59009ADE
P 5450 7500
F 0 "#PWR05" H 5450 7500 30  0001 C CNN
F 1 "GND" H 5450 7430 30  0001 C CNN
F 2 "" H 5450 7500 60  0000 C CNN
F 3 "" H 5450 7500 60  0000 C CNN
	1    5450 7500
	1    0    0    -1  
$EndComp
$Comp
L C C1
U 1 1 59009AE9
P 2850 5600
F 0 "C1" H 2850 5700 40  0000 L CNN
F 1 "10u" H 2856 5515 40  0000 L CNN
F 2 "SM1206" H 2888 5450 30  0001 C CNN
F 3 "" H 2850 5600 60  0001 C CNN
F 4 "Taiyo Yuden" H 2850 5600 60  0001 C CNN "Manufacturer"
F 5 "TMK316AB7106KLHT" H 2850 5600 60  0001 C CNN "P/N"
	1    2850 5600
	0    -1   -1   0   
$EndComp
$Comp
L C C3
U 1 1 59009AF4
P 5450 6850
F 0 "C3" H 5450 6950 40  0000 L CNN
F 1 "22u" H 5456 6765 40  0000 L CNN
F 2 "SM1210" H 5488 6700 30  0001 C CNN
F 3 "" H 5450 6850 60  0001 C CNN
F 4 "Taiyo Yuden" H 5450 6850 60  0001 C CNN "Manufacturer"
F 5 "EMK325B7226KM-PR" H 5450 6850 60  0001 C CNN "P/N"
	1    5450 6850
	1    0    0    -1  
$EndComp
$Comp
L MOS_P Q1
U 1 1 59009AFF
P 6200 6050
F 0 "Q1" V 6400 6100 60  0000 R CNN
F 1 "NTR4101P" V 6140 6570 50  0000 R CNN
F 2 "~" H 6200 6050 60  0000 C CNN
F 3 "" H 6200 6050 60  0001 C CNN
F 4 "On Semiconductor" H 6200 6050 60  0001 C CNN "Manufacturer"
F 5 "NTR4101P" H 6200 6050 60  0001 C CNN "P/N"
	1    6200 6050
	0    -1   1    0   
$EndComp
$Comp
L LED D1
U 1 1 59009B15
P 5800 7150
F 0 "D1" H 5800 7250 50  0000 C CNN
F 1 "LED_R" H 5800 7000 50  0000 C CNN
F 2 "SM_0603_MD" H 5800 7150 60  0001 C CNN
F 3 "" H 5800 7150 60  0001 C CNN
F 4 "Vishay" H 5800 7150 60  0001 C CNN "Manufacturer"
F 5 "TLMY1000-GS08" H 5800 7150 60  0001 C CNN "P/N"
	1    5800 7150
	0    1    1    0   
$EndComp
$Comp
L R R8
U 1 1 59009B20
P 5800 6550
F 0 "R8" V 5900 6600 40  0000 C CNN
F 1 "750" V 5807 6551 40  0000 C CNN
F 2 "SM0603" V 5730 6550 30  0001 C CNN
F 3 "" H 5800 6550 30  0001 C CNN
F 4 "Panasonic" H 5800 6550 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ751V" H 5800 6550 60  0001 C CNN "P/N"
	1    5800 6550
	-1   0    0    1   
$EndComp
Text Notes 3850 5650 0    60   ~ 0
Power supply\n
$Comp
L +3.3V #PWR06
U 1 1 59009B27
P 6650 6050
F 0 "#PWR06" H 6650 6010 30  0001 C CNN
F 1 "+3.3V" H 6650 6160 30  0000 C CNN
F 2 "~" H 6650 6050 60  0000 C CNN
F 3 "~" H 6650 6050 60  0000 C CNN
	1    6650 6050
	1    0    0    -1  
$EndComp
$Comp
L NPN_DIGITAL Q3
U 1 1 59009B32
P 2150 6450
F 0 "Q3" H 2400 6200 50  0000 R CNN
F 1 "PDTC124XT" H 2130 6590 50  0000 R CNN
F 2 "SOT23_MD" H 2150 6450 60  0001 C CNN
F 3 "" H 2150 6450 60  0001 C CNN
F 4 "NXP" H 2150 6450 60  0001 C CNN "Manufacturer"
F 5 "PDTC124XT" H 2150 6450 60  0001 C CNN "P/N"
	1    2150 6450
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR07
U 1 1 59009B3E
P 3150 5700
F 0 "#PWR07" H 3150 5700 30  0001 C CNN
F 1 "GND" H 3150 5630 30  0001 C CNN
F 2 "~" H 3150 5700 60  0000 C CNN
F 3 "~" H 3150 5700 60  0000 C CNN
	1    3150 5700
	1    0    0    -1  
$EndComp
$Comp
L +12V_BUS #PWR08
U 1 1 59009B44
P 2450 5450
F 0 "#PWR08" H 2450 5400 20  0001 C CNN
F 1 "+12V_BUS" H 2450 5550 30  0000 C CNN
F 2 "~" H 2450 5450 60  0000 C CNN
F 3 "~" H 2450 5450 60  0000 C CNN
	1    2450 5450
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR09
U 1 1 59009B4A
P 2250 7100
F 0 "#PWR09" H 2250 7100 30  0001 C CNN
F 1 "GND" H 2250 7030 30  0001 C CNN
F 2 "~" H 2250 7100 60  0000 C CNN
F 3 "~" H 2250 7100 60  0000 C CNN
	1    2250 7100
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR010
U 1 1 59009B50
P 5800 7500
F 0 "#PWR010" H 5800 7500 30  0001 C CNN
F 1 "GND" H 5800 7430 30  0001 C CNN
F 2 "" H 5800 7500 60  0000 C CNN
F 3 "" H 5800 7500 60  0000 C CNN
	1    5800 7500
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR011
U 1 1 59009B8F
P 5450 5850
F 0 "#PWR011" H 5450 5850 30  0001 C CNN
F 1 "GND" H 5450 5780 30  0001 C CNN
F 2 "" H 5450 5850 60  0000 C CNN
F 3 "" H 5450 5850 60  0000 C CNN
	1    5450 5850
	1    0    0    -1  
$EndComp
$Comp
L BID_TVS TVS2
U 1 1 59009B9A
P 5800 5650
F 0 "TVS2" H 5950 5750 40  0000 C CNN
F 1 "ESD5B5.0ST1G" H 6040 5690 30  0000 C CNN
F 2 "SOD-523_MD" V 5500 5650 60  0001 C CNN
F 3 "" H 6050 5700 60  0001 C CNN
F 4 "On Semiconductor" H 5800 5650 60  0001 C CNN "Manufacturer"
F 5 "ESD5B5.0ST1G" H 5800 5650 60  0001 C CNN "P/N"
	1    5800 5650
	0    -1   -1   0   
$EndComp
$Comp
L R R9
U 1 1 59009BA7
P 6200 5200
F 0 "R9" V 6300 5300 40  0000 C CNN
F 1 "120" V 6207 5201 40  0000 C CNN
F 2 "SM0603" V 6130 5200 30  0001 C CNN
F 3 "" H 6200 5200 30  0001 C CNN
F 4 "Panasonic" H 6200 5200 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ121V" H 6200 5200 60  0001 C CNN "P/N"
	1    6200 5200
	-1   0    0    1   
$EndComp
$Comp
L +5V_TLP #PWR012
U 1 1 59009BAF
P 1450 6150
F 0 "#PWR012" H 1450 6240 20  0001 C CNN
F 1 "+5V_TLP" H 1450 6240 30  0000 C CNN
F 2 "~" H 1450 6150 60  0000 C CNN
F 3 "~" H 1450 6150 60  0000 C CNN
	1    1450 6150
	1    0    0    -1  
$EndComp
$Comp
L +5V_TLP #PWR013
U 1 1 59009BB5
P 6200 4850
F 0 "#PWR013" H 6200 4940 20  0001 C CNN
F 1 "+5V_TLP" H 6200 4940 30  0000 C CNN
F 2 "~" H 6200 4850 60  0000 C CNN
F 3 "~" H 6200 4850 60  0000 C CNN
	1    6200 4850
	1    0    0    -1  
$EndComp
$Comp
L SN65HVD11 U2
U 1 1 5900A8B7
P 4500 1850
F 0 "U2" H 4500 1750 50  0000 C CNN
F 1 "SN65HVD11" H 4500 1950 50  0000 C CNN
F 2 "MODULE" H 4500 1850 50  0001 C CNN
F 3 "http://www.farnell.com/datasheets/1808277.pdf" H 4500 1850 50  0001 C CNN
F 4 "Texas Instruments" H 4500 1850 60  0001 C CNN "Manufacturer"
F 5 "SN65HVD11D" H 4500 1850 60  0001 C CNN "P/N"
	1    4500 1850
	1    0    0    -1  
$EndComp
$Comp
L CDSOT23-SM712 TVS1
U 1 1 5900A8C2
P 6350 1550
F 0 "TVS1" H 6600 1650 40  0000 C CNN
F 1 "CDSOT23-SM712" H 6750 1500 30  0000 C CNN
F 2 "~" V 6050 1550 60  0000 C CNN
F 3 "http://www.farnell.com/datasheets/1670933.pdf" V 6050 1550 60  0001 C CNN
F 4 "Bourns" H 6350 1550 60  0001 C CNN "Manufacturer"
F 5 "CDSOT23-SM712" H 6350 1550 60  0001 C CNN "P/N"
	1    6350 1550
	-1   0    0    1   
$EndComp
$Comp
L R R10
U 1 1 5900A8D5
P 6900 1800
F 0 "R10" V 6950 1550 40  0000 C CNN
F 1 "10" V 6907 1801 40  0000 C CNN
F 2 "SM0805" V 6830 1800 30  0001 C CNN
F 3 "" H 6900 1800 30  0001 C CNN
F 4 "Panasonic" H 6900 1800 60  0001 C CNN "Manufacturer"
F 5 "ERJ-P06J100V" H 6900 1800 60  0001 C CNN "P/N"
	1    6900 1800
	0    -1   -1   0   
$EndComp
$Comp
L C C2
U 1 1 5900A8F1
P 5900 1200
F 0 "C2" H 5900 1300 40  0000 L CNN
F 1 "100n" H 5906 1115 40  0000 L CNN
F 2 "SM0603" H 5938 1050 30  0001 C CNN
F 3 "" H 5900 1200 60  0001 C CNN
F 4 "Taiyo Yuden" H 5900 1200 60  0001 C CNN "Manufacturer"
F 5 "EMK107B7104KA-T" H 5900 1200 60  0001 C CNN "P/N"
	1    5900 1200
	0    1    -1   0   
$EndComp
Text Notes 4450 1450 0    60   ~ 0
RS-485 transceiver
$Comp
L +3.3V #PWR014
U 1 1 5900A938
P 5600 900
F 0 "#PWR014" H 5600 860 30  0001 C CNN
F 1 "+3.3V" H 5600 1010 30  0000 C CNN
F 2 "~" H 5600 900 60  0000 C CNN
F 3 "~" H 5600 900 60  0000 C CNN
	1    5600 900 
	1    0    0    -1  
$EndComp
$Comp
L R R6
U 1 1 5900A975
P 5750 3950
F 0 "R6" V 5850 4050 40  0000 C CNN
F 1 "120" V 5757 3951 40  0000 C CNN
F 2 "SM1206" V 5680 3950 30  0001 C CNN
F 3 "" H 5750 3950 30  0001 C CNN
F 4 "Panasonic" H 5750 3950 60  0001 C CNN "Manufacturer"
F 5 "ERJ-P08J121V" H 5750 3950 60  0001 C CNN "P/N"
	1    5750 3950
	0    1    1    0   
$EndComp
$Comp
L R R3
U 1 1 5900A980
P 5350 3600
F 0 "R3" V 5450 3700 40  0000 C CNN
F 1 "1k2" V 5357 3601 40  0000 C CNN
F 2 "SM0805" V 5280 3600 30  0001 C CNN
F 3 "" H 5350 3600 30  0001 C CNN
F 4 "Panasonic" H 5350 3600 60  0001 C CNN "Manufacturer"
F 5 "ERJ-6ENF1201V" H 5350 3600 60  0001 C CNN "P/N"
	1    5350 3600
	-1   0    0    -1  
$EndComp
$Comp
L CONN_3X2 P1
U 1 1 5900B89B
P 1450 1000
F 0 "P1" H 1450 1250 50  0000 C CNN
F 1 "UART1" V 1450 1050 40  0000 C CNN
F 2 "" H 1450 1000 60  0000 C CNN
F 3 "" H 1450 1000 60  0001 C CNN
F 4 "3M" H 1450 1000 60  0001 C CNN "Manufacturer"
F 5 "961206-5604-AR" H 1450 1000 60  0001 C CNN "P/N"
	1    1450 1000
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR015
U 1 1 5900B8A1
P 2150 800
F 0 "#PWR015" H 2150 800 30  0001 C CNN
F 1 "GND" H 2150 730 30  0001 C CNN
F 2 "" H 2150 800 60  0000 C CNN
F 3 "" H 2150 800 60  0000 C CNN
	1    2150 800 
	1    0    0    -1  
$EndComp
Text Label 550  850  0    60   ~ 0
UART1_RTS
Text Label 550  950  0    60   ~ 0
UART1_TX
Text Label 550  1050 0    60   ~ 0
UART1_RX
Text Label 2350 950  2    60   ~ 0
UART1_CTS
$Comp
L CONN_4 P3
U 1 1 5900B8B0
P 8150 1750
F 0 "P3" H 8150 2000 50  0000 C CNN
F 1 "RS485" V 8150 1750 50  0000 C CNN
F 2 "" H 8150 1750 60  0000 C CNN
F 3 "" H 8150 1750 60  0001 C CNN
F 4 "Phoenix Contact" H 8150 1750 60  0001 C CNN "Manufacturer"
F 5 "1877504" H 8150 1750 60  0001 C CNN "P/N"
	1    8150 1750
	1    0    0    1   
$EndComp
Wire Wire Line
	550  850  1050 850 
Wire Wire Line
	550  950  1050 950 
Wire Wire Line
	550  1050 1050 1050
Wire Wire Line
	1850 950  2350 950 
Wire Wire Line
	2150 800  2150 750 
Wire Wire Line
	2150 750  1950 750 
Wire Wire Line
	1950 750  1950 850 
Wire Wire Line
	1950 850  1850 850 
Wire Wire Line
	1850 1050 2550 1050
Wire Wire Line
	2550 1050 2550 950 
Text Label 650  1450 0    60   ~ 0
EXT_AIN0
Text Label 2250 1650 2    60   ~ 0
I2C0_SCL
Text Label 2250 1750 2    60   ~ 0
I2C1_SCL
Text Label 650  1750 0    60   ~ 0
I2C1_SDA
Wire Wire Line
	650  1650 1050 1650
Text Label 650  1650 0    60   ~ 0
I2C0_SDA
Wire Wire Line
	2250 1550 1850 1550
Wire Wire Line
	1050 1550 650  1550
Text Notes 550  1950 0    60   ~ 0
Right side female headers
Text Notes 550  650  0    60   ~ 0
Left side male headers
$Comp
L CONN_5X2 P0
U 1 1 5900B8E3
P 1450 1550
F 0 "P0" H 1450 1850 50  0000 C CNN
F 1 "GPIO0" V 1450 1550 40  0000 C CNN
F 2 "~" H 1450 1550 60  0001 C CNN
F 3 "" H 1450 1550 60  0001 C CNN
F 4 "3M" H 1450 1550 60  0001 C CNN "Manufacturer"
F 5 "961210-5604-AR" H 1450 1550 60  0001 C CNN "P/N"
	1    1450 1550
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR016
U 1 1 5900B8E9
P 2000 1300
F 0 "#PWR016" H 2000 1300 30  0001 C CNN
F 1 "GND" H 2000 1230 30  0001 C CNN
F 2 "" H 2000 1300 60  0000 C CNN
F 3 "" H 2000 1300 60  0000 C CNN
	1    2000 1300
	1    0    0    -1  
$EndComp
Wire Wire Line
	2000 1300 2000 1250
Wire Wire Line
	2000 1250 1900 1250
Wire Wire Line
	1900 1250 1900 1350
Wire Wire Line
	1900 1350 1850 1350
Wire Wire Line
	950  1350 950  1300
Wire Wire Line
	950  1350 1050 1350
Wire Wire Line
	2250 1650 1850 1650
Wire Wire Line
	1850 1750 2250 1750
Wire Wire Line
	1050 1750 650  1750
$Comp
L +3.3V #PWR017
U 1 1 5900B8F8
P 2550 950
F 0 "#PWR017" H 2550 910 30  0001 C CNN
F 1 "+3.3V" H 2550 1060 30  0000 C CNN
F 2 "~" H 2550 950 60  0000 C CNN
F 3 "~" H 2550 950 60  0000 C CNN
	1    2550 950 
	1    0    0    -1  
$EndComp
$Comp
L +3.3V #PWR018
U 1 1 5900B8FE
P 950 1300
F 0 "#PWR018" H 950 1260 30  0001 C CNN
F 1 "+3.3V" H 950 1410 30  0000 C CNN
F 2 "~" H 950 1300 60  0000 C CNN
F 3 "~" H 950 1300 60  0000 C CNN
	1    950  1300
	1    0    0    -1  
$EndComp
$Comp
L +12V_BUS #PWR019
U 1 1 5900C766
P 7700 900
F 0 "#PWR019" H 7700 850 20  0001 C CNN
F 1 "+12V_BUS" H 7700 1000 30  0000 C CNN
F 2 "" H 7700 900 60  0000 C CNN
F 3 "" H 7700 900 60  0000 C CNN
	1    7700 900 
	1    0    0    -1  
$EndComp
$Comp
L MOS_P Q2
U 1 1 5900C77A
P 7600 1200
F 0 "Q2" V 7450 1100 60  0000 R CNN
F 1 "FDC658AP" V 7550 1000 50  0000 R CNN
F 2 "SOT-26_MD" H 7600 1200 60  0001 C CNN
F 3 "http://www.ts.com.tw/db/pictures/modules/PDT/PDT060207001/TSM3457_C07.pdf" H 7600 1200 60  0001 C CNN
F 4 "Fairchild" H 7600 1200 60  0001 C CNN "Manufacturer"
F 5 "FDC658AP" H 7600 1200 60  0001 C CNN "P/N"
	1    7600 1200
	1    0    0    1   
$EndComp
Text Notes 6750 2200 0    60   ~ 0
Transient & reverse polarity protections\nof power supply rail\n
$Comp
L BID_TVS TVS3
U 1 1 5900C791
P 6900 1600
F 0 "TVS3" H 7050 1700 40  0000 C CNN
F 1 "15V" H 7050 1500 30  0000 C CNN
F 2 "SMC" V 6600 1600 60  0001 C CNN
F 3 "" H 7150 1650 60  0001 C CNN
F 4 "Fairchild" H 6900 1600 60  0001 C CNN "Manufacturer"
F 5 "SMCJ15CA" H 6900 1600 60  0001 C CNN "P/N"
	1    6900 1600
	0    1    -1   0   
$EndComp
$Comp
L GND #PWR020
U 1 1 5900D6C9
P 3300 4850
F 0 "#PWR020" H 3300 4850 30  0001 C CNN
F 1 "GND" H 3300 4780 30  0001 C CNN
F 2 "" H 3300 4850 60  0000 C CNN
F 3 "" H 3300 4850 60  0000 C CNN
	1    3300 4850
	1    0    0    -1  
$EndComp
$Comp
L C C5
U 1 1 5900D6D5
P 3600 4550
F 0 "C5" H 3600 4650 40  0000 L CNN
F 1 "10n" H 3606 4465 40  0000 L CNN
F 2 "SM0603" H 3638 4400 30  0001 C CNN
F 3 "" H 3600 4550 60  0001 C CNN
F 4 "Murata" H 3600 4550 60  0001 C CNN "Manufacturer"
F 5 "GRM188R71H103JA01D" H 3600 4550 60  0001 C CNN "P/N"
	1    3600 4550
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR021
U 1 1 5900D6DB
P 3600 4850
F 0 "#PWR021" H 3600 4850 30  0001 C CNN
F 1 "GND" H 3600 4780 30  0001 C CNN
F 2 "" H 3600 4850 60  0000 C CNN
F 3 "" H 3600 4850 60  0000 C CNN
	1    3600 4850
	1    0    0    -1  
$EndComp
Text Label 4050 4200 2    60   ~ 0
MON+5V
Text Label 1400 4900 1    60   ~ 0
I2C0_SCL
Text Label 1000 4900 1    60   ~ 0
I2C1_SCL
Text Label 1200 4900 1    60   ~ 0
I2C1_SDA
$Comp
L R R12
U 1 1 5900D6F1
P 800 4250
F 0 "R12" V 880 4250 40  0000 C CNN
F 1 "4k7" V 807 4251 40  0000 C CNN
F 2 "SM0603" V 730 4250 30  0001 C CNN
F 3 "" H 800 4250 30  0001 C CNN
F 4 "Panasonic" H 800 4250 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ472V" H 800 4250 60  0001 C CNN "P/N"
	1    800  4250
	1    0    0    -1  
$EndComp
Wire Wire Line
	3300 3550 3300 3650
Wire Wire Line
	3300 4150 3300 4250
Wire Wire Line
	3300 4750 3300 4850
Wire Wire Line
	3300 4200 4050 4200
Wire Wire Line
	3600 4200 3600 4350
Connection ~ 3300 4200
Wire Wire Line
	3600 4750 3600 4850
Connection ~ 3600 4200
Wire Wire Line
	800  4500 800  4900
Text Label 800  4900 1    60   ~ 0
I2C0_SDA
Wire Wire Line
	1000 4500 1000 4900
Wire Wire Line
	1200 4500 1200 4900
Wire Wire Line
	1400 4500 1400 4900
Wire Wire Line
	800  4000 800  3950
Wire Wire Line
	800  3950 1400 3950
Wire Wire Line
	1400 3950 1400 4000
Wire Wire Line
	1200 4000 1200 3950
Connection ~ 1200 3950
Wire Wire Line
	1000 4000 1000 3950
Connection ~ 1000 3950
Wire Wire Line
	1100 3900 1100 3950
Connection ~ 1100 3950
Text Notes 750  3600 0    60   ~ 0
I2C: generic \npull-up resistor
$Comp
L R R19
U 1 1 5900D785
P 3300 3900
F 0 "R19" V 3400 3900 40  0000 C CNN
F 1 "10k" V 3307 3901 40  0000 C CNN
F 2 "SM0603" V 3230 3900 30  0001 C CNN
F 3 "" H 3300 3900 30  0001 C CNN
F 4 "Panasonic" H 3300 3900 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3EKF1002V" H 3300 3900 60  0001 C CNN "P/N"
	1    3300 3900
	1    0    0    -1  
$EndComp
$Comp
L +3.3V #PWR022
U 1 1 5900D78B
P 1100 3900
F 0 "#PWR022" H 1100 3860 30  0001 C CNN
F 1 "+3.3V" H 1100 4010 30  0000 C CNN
F 2 "~" H 1100 3900 60  0000 C CNN
F 3 "~" H 1100 3900 60  0000 C CNN
	1    1100 3900
	1    0    0    -1  
$EndComp
$Comp
L TI_BOOSTER_40_J1 J1
U 1 1 5900E7E4
P 8150 3650
F 0 "J1" H 8100 4300 60  0000 C CNN
F 1 "TI_BOOSTER_40_J1" H 8150 3000 60  0000 C CNN
F 2 "SIL-10" H 8150 3650 60  0001 C CNN
F 3 "" H 8150 3650 60  0001 C CNN
F 4 "Amphenol FCi" H 8150 3650 60  0001 C CNN "Manufacturer"
F 5 "77313-122-20LF" H 8150 3650 60  0001 C CNN "P/N"
F 6 "also covers J3" H 8150 3650 60  0001 C CNN "Comment"
	1    8150 3650
	1    0    0    -1  
$EndComp
$Comp
L TI_BOOSTER_40_J2 J2
U 1 1 5900E7F1
P 10400 5300
F 0 "J2" H 10350 5950 60  0000 C CNN
F 1 "TI_BOOSTER_40_J2" H 10400 4650 60  0000 C CNN
F 2 "SIL-10" H 10400 5300 60  0001 C CNN
F 3 "" H 10400 5300 60  0001 C CNN
F 4 "Amphenol FCi" H 10400 5300 60  0001 C CNN "Manufacturer"
F 5 "77313-122-20LF" H 10400 5300 60  0001 C CNN "P/N"
F 6 "also covers J4" H 10400 5300 60  0001 C CNN "Comment"
	1    10400 5300
	1    0    0    -1  
$EndComp
$Comp
L TI_BOOSTER_40_J3 J3
U 1 1 5900E7FE
P 10400 3650
F 0 "J3" H 10350 4300 60  0000 C CNN
F 1 "TI_BOOSTER_40_J3" H 10400 3000 60  0000 C CNN
F 2 "SIL-10" H 10400 3650 60  0001 C CNN
F 3 "" H 10400 3650 60  0001 C CNN
	1    10400 3650
	1    0    0    -1  
$EndComp
$Comp
L TI_BOOSTER_40_J4 J4
U 1 1 5900E80B
P 8150 5300
F 0 "J4" H 8100 5950 60  0000 C CNN
F 1 "TI_BOOSTER_40_J4" H 8150 4650 60  0000 C CNN
F 2 "SIL-10" H 8150 5300 60  0001 C CNN
F 3 "" H 8150 5300 60  0001 C CNN
	1    8150 5300
	1    0    0    -1  
$EndComp
Text Label 7000 5150 0    60   ~ 0
UART1_RTS
Text Label 7000 3500 0    60   ~ 0
UART1_TX
Text Label 7000 3400 0    60   ~ 0
UART1_RX
Text Label 7000 5250 0    60   ~ 0
UART1_CTS
Text Label 7000 5650 0    60   ~ 0
UART2_TX
Text Label 7000 5550 0    60   ~ 0
UART2_RX
Text Label 7000 4000 0    60   ~ 0
I2C1_SCL
Text Label 7000 4100 0    60   ~ 0
I2C1_SDA
Text Label 9250 3800 0    60   ~ 0
MON+12V
Text Label 9250 3900 0    60   ~ 0
EXT_AIN1
Text Label 9250 4000 0    60   ~ 0
EXT_AIN0
Text Label 7050 4850 0    60   ~ 0
LED_B
Text Label 7050 4950 0    60   ~ 0
LED_G
Text Label 7000 5050 0    60   ~ 0
I2C0_SDA
Text Label 7000 5350 0    60   ~ 0
UART3_RX
Text Label 7000 5450 0    60   ~ 0
UART3_TX
Text Label 7050 5750 0    60   ~ 0
SW1
$Comp
L GND #PWR023
U 1 1 5900E825
P 9050 4900
F 0 "#PWR023" H 9050 4900 30  0001 C CNN
F 1 "GND" H 9050 4830 30  0001 C CNN
F 2 "" H 9050 4900 60  0000 C CNN
F 3 "" H 9050 4900 60  0000 C CNN
	1    9050 4900
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR024
U 1 1 5900E82B
P 8800 3050
F 0 "#PWR024" H 8800 3050 30  0001 C CNN
F 1 "GND" H 8800 2980 30  0001 C CNN
F 2 "" H 8800 3050 60  0000 C CNN
F 3 "" H 8800 3050 60  0000 C CNN
	1    8800 3050
	1    0    0    -1  
$EndComp
Text Label 9250 4950 0    60   ~ 0
I2C0_SCL
NoConn ~ 9250 5150
NoConn ~ 9250 5250
NoConn ~ 9250 4100
NoConn ~ 7000 4850
NoConn ~ 7000 4950
NoConn ~ 7000 5750
Wire Wire Line
	7000 5150 7550 5150
Wire Wire Line
	7000 5250 7550 5250
Wire Wire Line
	7000 3400 7550 3400
Wire Wire Line
	7000 3500 7550 3500
Wire Wire Line
	7550 3300 7000 3300
Wire Wire Line
	7000 5550 7550 5550
Wire Wire Line
	7000 5650 7550 5650
Wire Wire Line
	9250 3500 9800 3500
Wire Wire Line
	7550 3600 7000 3600
Wire Wire Line
	7550 3700 7000 3700
Wire Wire Line
	7550 3900 7000 3900
Wire Wire Line
	7550 4000 7000 4000
Wire Wire Line
	7550 4100 7000 4100
Wire Wire Line
	9800 4950 9250 4950
Wire Wire Line
	9800 5050 9250 5050
Wire Wire Line
	9800 5150 9250 5150
Wire Wire Line
	9800 5250 9250 5250
Wire Wire Line
	9800 5350 9250 5350
Wire Wire Line
	9800 5450 9250 5450
Wire Wire Line
	9800 5550 9250 5550
Wire Wire Line
	9800 5650 9250 5650
Wire Wire Line
	9800 3400 9250 3400
Wire Wire Line
	9800 3600 9250 3600
Wire Wire Line
	9800 3700 9250 3700
Wire Wire Line
	9800 3800 9250 3800
Wire Wire Line
	9800 4100 9250 4100
Wire Wire Line
	7550 4850 7000 4850
Wire Wire Line
	7550 4950 7000 4950
Wire Wire Line
	7550 5050 7000 5050
Wire Wire Line
	7550 5350 7000 5350
Wire Wire Line
	7550 5750 7000 5750
Wire Wire Line
	9050 4900 9050 4850
Wire Wire Line
	9050 4850 9800 4850
Wire Wire Line
	9250 5750 9800 5750
Wire Wire Line
	8900 3300 9800 3300
Wire Wire Line
	7550 3200 6800 3200
Wire Wire Line
	6800 3200 6800 3100
Wire Wire Line
	8900 3300 8900 3000
Wire Wire Line
	8900 3000 8800 3000
Wire Wire Line
	8800 3000 8800 3050
Text Notes 8550 4550 0    60   ~ 0
4x Stackable 10 pin headers
$Comp
L +3.3V #PWR025
U 1 1 5900E876
P 6800 3100
F 0 "#PWR025" H 6800 3060 30  0001 C CNN
F 1 "+3.3V" H 6800 3210 30  0000 C CNN
F 2 "~" H 6800 3100 60  0000 C CNN
F 3 "~" H 6800 3100 60  0000 C CNN
	1    6800 3100
	1    0    0    -1  
$EndComp
Wire Wire Line
	9050 3200 9050 3100
$Comp
L +5V_TLP #PWR026
U 1 1 5900E87E
P 9050 3100
F 0 "#PWR026" H 9050 3190 20  0001 C CNN
F 1 "+5V_TLP" H 9050 3190 30  0000 C CNN
F 2 "~" H 9050 3100 60  0000 C CNN
F 3 "~" H 9050 3100 60  0000 C CNN
	1    9050 3100
	1    0    0    -1  
$EndComp
Text Label 7200 1900 0    60   ~ 0
RS485-A
$Comp
L GND #PWR027
U 1 1 5900EC91
P 6600 2100
F 0 "#PWR027" H 6600 2100 30  0001 C CNN
F 1 "GND" H 6600 2030 30  0001 C CNN
F 2 "" H 6600 2100 60  0000 C CNN
F 3 "" H 6600 2100 60  0000 C CNN
	1    6600 2100
	1    0    0    -1  
$EndComp
Text Label 7200 1800 0    60   ~ 0
RS485-B
Wire Wire Line
	7150 1800 7750 1800
Wire Wire Line
	7700 1900 7150 1900
Wire Wire Line
	7100 1600 7800 1600
Wire Wire Line
	6600 1700 7800 1700
Wire Wire Line
	6600 1200 6600 2100
Wire Wire Line
	6600 1600 6700 1600
Text Label 7200 1600 0    60   ~ 0
RS485+V
Wire Wire Line
	6100 1200 7400 1200
Connection ~ 6600 1600
Wire Wire Line
	7700 1600 7700 1400
Wire Wire Line
	7700 900  7700 1000
Connection ~ 6600 1700
Wire Wire Line
	6350 1400 6350 1200
Connection ~ 6600 1200
Wire Wire Line
	5350 1800 6650 1800
Wire Wire Line
	6450 1800 6450 1750
Wire Wire Line
	5350 1900 6650 1900
Wire Wire Line
	6250 1900 6250 1750
$Comp
L R R11
U 1 1 5900DEE3
P 6900 1900
F 0 "R11" V 6950 1650 40  0000 C CNN
F 1 "10" V 6907 1901 40  0000 C CNN
F 2 "SM0805" V 6830 1900 30  0001 C CNN
F 3 "" H 6900 1900 30  0001 C CNN
F 4 "Panasonic" H 6900 1900 60  0001 C CNN "Manufacturer"
F 5 "ERJ-P06J100V" H 6900 1900 60  0001 C CNN "P/N"
	1    6900 1900
	0    -1   -1   0   
$EndComp
$Comp
L CONN_4 P6
U 1 1 5900E106
P 5750 2750
F 0 "P6" H 5750 3000 50  0000 C CNN
F 1 "RS485-TERM" V 5750 2750 50  0000 C CNN
F 2 "" H 5750 2750 60  0000 C CNN
F 3 "" H 5750 2750 60  0001 C CNN
F 4 "Molex" H 5750 2750 60  0001 C CNN "Manufacturer"
F 5 "22-16-2040" H 5750 2750 60  0001 C CNN "P/N"
	1    5750 2750
	0    1    1    0   
$EndComp
Wire Wire Line
	5700 1800 5700 2400
Connection ~ 6450 1800
Wire Wire Line
	5800 1900 5800 2400
Connection ~ 6250 1900
$Comp
L CONN_4 P7
U 1 1 5901A96F
P 5750 3000
F 0 "P7" H 5750 3250 50  0000 C CNN
F 1 "RS485-TERM" V 5750 3000 50  0000 C CNN
F 2 "" H 5750 3000 60  0000 C CNN
F 3 "" H 5750 3000 60  0001 C CNN
F 4 "3M" H 5750 3000 60  0001 C CNN "Manufacturer"
F 5 "961104-6804-AR" H 5750 3000 60  0001 C CNN "P/N"
	1    5750 3000
	0    1    -1   0   
$EndComp
Wire Wire Line
	5600 3350 5350 3350
Wire Wire Line
	5350 3850 5350 3950
Wire Wire Line
	5350 3950 5500 3950
Wire Wire Line
	6000 3950 6150 3950
Wire Wire Line
	6150 3950 6150 3850
Wire Wire Line
	6150 3350 5900 3350
Wire Wire Line
	5800 3350 5800 3700
Wire Wire Line
	5800 3700 6000 3700
Wire Wire Line
	6000 3700 6000 3950
Wire Wire Line
	5700 3350 5700 3700
Wire Wire Line
	5700 3700 5500 3700
Wire Wire Line
	5500 3700 5500 3950
Wire Wire Line
	5900 2400 5900 2000
Wire Wire Line
	5350 2000 6600 2000
Connection ~ 6600 2000
Wire Wire Line
	5600 900  5600 2400
Wire Wire Line
	5350 1700 5600 1700
Connection ~ 5600 1700
Connection ~ 5700 1800
Connection ~ 5800 1900
Connection ~ 5900 2000
Connection ~ 6350 1200
Wire Wire Line
	5700 1200 5600 1200
Connection ~ 5600 1200
$Comp
L GND #PWR028
U 1 1 5901B873
P 2050 4850
F 0 "#PWR028" H 2050 4850 30  0001 C CNN
F 1 "GND" H 2050 4780 30  0001 C CNN
F 2 "" H 2050 4850 60  0000 C CNN
F 3 "" H 2050 4850 60  0000 C CNN
	1    2050 4850
	1    0    0    -1  
$EndComp
Text Notes 1900 4600 1    60   ~ 0
Divider ratio=6.236\n
$Comp
L C C4
U 1 1 5901B87F
P 2350 4550
F 0 "C4" H 2350 4650 40  0000 L CNN
F 1 "10n" H 2356 4465 40  0000 L CNN
F 2 "SM0603" H 2388 4400 30  0001 C CNN
F 3 "" H 2350 4550 60  0001 C CNN
F 4 "Murata" H 2350 4550 60  0001 C CNN "Manufacturer"
F 5 "GRM188R71H103JA01D" H 2350 4550 60  0001 C CNN "P/N"
	1    2350 4550
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR029
U 1 1 5901B885
P 2350 4850
F 0 "#PWR029" H 2350 4850 30  0001 C CNN
F 1 "GND" H 2350 4780 30  0001 C CNN
F 2 "" H 2350 4850 60  0000 C CNN
F 3 "" H 2350 4850 60  0000 C CNN
	1    2350 4850
	1    0    0    -1  
$EndComp
Text Label 2800 4200 2    60   ~ 0
MON+12V
$Comp
L +12V_BUS #PWR030
U 1 1 5901B88C
P 2050 3550
F 0 "#PWR030" H 2050 3500 20  0001 C CNN
F 1 "+12V_BUS" H 2050 3650 30  0000 C CNN
F 2 "" H 2050 3550 60  0000 C CNN
F 3 "" H 2050 3550 60  0000 C CNN
	1    2050 3550
	1    0    0    -1  
$EndComp
Wire Wire Line
	2050 3550 2050 3650
Wire Wire Line
	2050 4150 2050 4250
Wire Wire Line
	2050 4750 2050 4850
Wire Wire Line
	2050 4200 2800 4200
Wire Wire Line
	2350 4200 2350 4350
Connection ~ 2050 4200
Wire Wire Line
	2350 4750 2350 4850
Connection ~ 2350 4200
$Comp
L R R17
U 1 1 5901B89F
P 2050 4500
F 0 "R17" V 2150 4500 40  0000 C CNN
F 1 "1k91" V 2057 4501 40  0000 C CNN
F 2 "SM0603" V 1980 4500 30  0001 C CNN
F 3 "" H 2050 4500 30  0001 C CNN
F 4 "Panasonic" H 2050 4500 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3EKF1911V" H 2050 4500 60  0001 C CNN "P/N"
	1    2050 4500
	1    0    0    -1  
$EndComp
$Comp
L R R16
U 1 1 5901B8AA
P 2050 3900
F 0 "R16" V 2150 3900 40  0000 C CNN
F 1 "10k" V 2057 3901 40  0000 C CNN
F 2 "SM0603" V 1980 3900 30  0001 C CNN
F 3 "" H 2050 3900 30  0001 C CNN
F 4 "Panasonic" H 2050 3900 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3EKF1002V" H 2050 3900 60  0001 C CNN "P/N"
	1    2050 3900
	1    0    0    -1  
$EndComp
$Comp
L +5V_TLP #PWR031
U 1 1 5901B8B0
P 3300 3550
F 0 "#PWR031" H 3300 3640 20  0001 C CNN
F 1 "+5V_TLP" H 3300 3640 30  0000 C CNN
F 2 "~" H 3300 3550 60  0000 C CNN
F 3 "~" H 3300 3550 60  0000 C CNN
	1    3300 3550
	1    0    0    -1  
$EndComp
$Comp
L R R20
U 1 1 5901B8BB
P 3300 4500
F 0 "R20" V 3400 4500 40  0000 C CNN
F 1 "10k" V 3307 4501 40  0000 C CNN
F 2 "SM0603" V 3230 4500 30  0001 C CNN
F 3 "" H 3300 4500 30  0001 C CNN
F 4 "Panasonic" H 3300 4500 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3EKF1002V" H 3300 4500 60  0001 C CNN "P/N"
	1    3300 4500
	1    0    0    -1  
$EndComp
$Comp
L CONN_4X2 P2
U 1 1 5901B8C4
P 1450 2250
F 0 "P2" H 1450 2500 50  0000 C CNN
F 1 "DALI" V 1450 2250 40  0000 C CNN
F 2 "Female_4x2" H 1450 2250 60  0001 C CNN
F 3 "" H 1450 2250 60  0000 C CNN
F 4 "3M" H 1450 2250 60  0001 C CNN "Manufacturer"
F 5 "960208-7102-AR" H 1450 2250 60  0001 C CNN "P/N"
	1    1450 2250
	1    0    0    -1  
$EndComp
$Comp
L CONN_4X2 P5
U 1 1 59037DD5
P 1450 2850
F 0 "P5" H 1450 3100 50  0000 C CNN
F 1 "RELAY" V 1450 2850 40  0000 C CNN
F 2 "Female_4x2" H 1450 2850 60  0001 C CNN
F 3 "" H 1450 2850 60  0000 C CNN
F 4 "3M" H 1450 2850 60  0001 C CNN "Manufacturer"
F 5 "960208-7102-AR" H 1450 2850 60  0001 C CNN "P/N"
	1    1450 2850
	1    0    0    -1  
$EndComp
Text Label 10500 1600 0    60   ~ 0
RFM_SDN
Text Label 10500 1700 0    60   ~ 0
RFM_NIRQ
Text Label 10500 1800 0    60   ~ 0
RFM_SSEL
Text Label 10500 1900 0    60   ~ 0
RFM_SCLK
Text Label 10500 2000 0    60   ~ 0
RFM_MOSI
Text Label 10500 2100 0    60   ~ 0
RFM_MISO
Text Label 9250 2000 2    60   ~ 0
RFM_GPIO0
Text Label 9250 2100 2    60   ~ 0
RFM_GPIO1
Text Label 9250 2200 2    60   ~ 0
RFM_CLK
Text Label 9150 1500 0    60   ~ 0
ANT
Text Label 7000 3800 0    60   ~ 0
RFM_SDN
Text Label 7000 3900 0    60   ~ 0
RFM_MOSI
Text Label 1850 2100 0    60   ~ 0
UART2_RX
Text Label 1850 2200 0    60   ~ 0
UART2_TX
Text Label 1850 2700 0    60   ~ 0
UART5_RX
Text Label 1850 2800 0    60   ~ 0
UART5_TX
$Comp
L +3.3V #PWR032
U 1 1 59037FEC
P 1850 2300
F 0 "#PWR032" H 1850 2260 30  0001 C CNN
F 1 "+3.3V" H 1850 2410 30  0000 C CNN
F 2 "~" H 1850 2300 60  0000 C CNN
F 3 "~" H 1850 2300 60  0000 C CNN
	1    1850 2300
	0    1    1    0   
$EndComp
$Comp
L +5V_TLP #PWR033
U 1 1 59037FF2
P 1850 2400
F 0 "#PWR033" H 1850 2490 20  0001 C CNN
F 1 "+5V_TLP" H 1850 2490 30  0000 C CNN
F 2 "~" H 1850 2400 60  0000 C CNN
F 3 "~" H 1850 2400 60  0000 C CNN
	1    1850 2400
	0    1    1    0   
$EndComp
$Comp
L +3.3V #PWR034
U 1 1 59037FF8
P 1850 2900
F 0 "#PWR034" H 1850 2860 30  0001 C CNN
F 1 "+3.3V" H 1850 3010 30  0000 C CNN
F 2 "~" H 1850 2900 60  0000 C CNN
F 3 "~" H 1850 2900 60  0000 C CNN
	1    1850 2900
	0    1    1    0   
$EndComp
$Comp
L +5V_TLP #PWR035
U 1 1 59037FFE
P 1850 3000
F 0 "#PWR035" H 1850 3090 20  0001 C CNN
F 1 "+5V_TLP" H 1850 3090 30  0000 C CNN
F 2 "~" H 1850 3000 60  0000 C CNN
F 3 "~" H 1850 3000 60  0000 C CNN
	1    1850 3000
	0    1    1    0   
$EndComp
$Comp
L GND #PWR036
U 1 1 59038006
P 950 2500
F 0 "#PWR036" H 950 2500 30  0001 C CNN
F 1 "GND" H 950 2430 30  0001 C CNN
F 2 "" H 950 2500 60  0000 C CNN
F 3 "" H 950 2500 60  0000 C CNN
	1    950  2500
	1    0    0    -1  
$EndComp
$Comp
L GND #PWR037
U 1 1 59038015
P 950 3100
F 0 "#PWR037" H 950 3100 30  0001 C CNN
F 1 "GND" H 950 3030 30  0001 C CNN
F 2 "" H 950 3100 60  0000 C CNN
F 3 "" H 950 3100 60  0000 C CNN
	1    950  3100
	1    0    0    -1  
$EndComp
Wire Wire Line
	950  2900 950  3100
Wire Wire Line
	950  2900 1050 2900
Wire Wire Line
	1050 3000 950  3000
Connection ~ 950  3000
Wire Wire Line
	950  2300 950  2500
Wire Wire Line
	950  2300 1050 2300
Wire Wire Line
	1050 2400 950  2400
Connection ~ 950  2400
Text Label 1050 2100 2    60   ~ 0
UART2_EN#
Text Label 1050 2200 2    60   ~ 0
UART2_PWR
Text Label 1050 2800 2    60   ~ 0
UART5_PWR
Text Label 7000 3600 0    60   ~ 0
UART5_RX
Text Label 7000 3700 0    60   ~ 0
UART5_TX
Text Label 9250 5050 0    60   ~ 0
RFM_NIRQ
Text Label 9250 5550 0    60   ~ 0
RFM_MISO
Text Label 9250 5650 0    60   ~ 0
RFM_SSEL
Text Label 9250 5750 0    60   ~ 0
RFM_SCLK
Text Label 9250 3400 0    60   ~ 0
RFM_CLK
Text Label 9250 3600 0    60   ~ 0
RS485_RXEN#
Text Label 9250 3700 0    60   ~ 0
RS485_TXEN
Text Label 9300 4100 0    60   ~ 0
LED_R
Text Label 9300 5150 0    60   ~ 0
SW2
Text Label 9300 5250 0    60   ~ 0
RESET
Text Label 9250 3500 0    60   ~ 0
MON+5V
Text Label 650  1550 0    60   ~ 0
RFM_GPIO0
Text Label 2250 1550 2    60   ~ 0
RFM_GPIO1
Text Label 9250 5350 0    60   ~ 0
UART2_PWR
Text Label 9250 5450 0    60   ~ 0
UART2_EN#
Text Label 7000 3300 0    60   ~ 0
UART5_PWR
Text Label 3700 1700 2    60   ~ 0
UART3_RX
Text Label 3700 1800 2    60   ~ 0
RS485_RXEN#
Text Label 3700 1900 2    60   ~ 0
RS485_TXEN
Text Label 3700 2000 2    60   ~ 0
UART3_TX
Text Label 7600 1700 2    60   ~ 0
GND
Text Label 1050 2700 2    60   ~ 0
GND
Wire Wire Line
	7550 3800 7000 3800
Wire Wire Line
	9800 3200 9050 3200
Wire Wire Line
	7550 5450 7000 5450
Wire Wire Line
	1050 1450 650  1450
Text Label 2250 1450 2    60   ~ 0
EXT_AIN1
Wire Wire Line
	2250 1450 1850 1450
Wire Wire Line
	9800 3900 9250 3900
Wire Wire Line
	9800 4000 9250 4000
$Comp
L R R13
U 1 1 59084EF4
P 1000 4250
F 0 "R13" V 1080 4250 40  0000 C CNN
F 1 "4k7" V 1007 4251 40  0000 C CNN
F 2 "SM0603" V 930 4250 30  0001 C CNN
F 3 "" H 1000 4250 30  0001 C CNN
F 4 "Panasonic" H 1000 4250 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ472V" H 1000 4250 60  0001 C CNN "P/N"
	1    1000 4250
	1    0    0    -1  
$EndComp
$Comp
L R R14
U 1 1 59084EFC
P 1200 4250
F 0 "R14" V 1280 4250 40  0000 C CNN
F 1 "4k7" V 1207 4251 40  0000 C CNN
F 2 "SM0603" V 1130 4250 30  0001 C CNN
F 3 "" H 1200 4250 30  0001 C CNN
F 4 "Panasonic" H 1200 4250 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ472V" H 1200 4250 60  0001 C CNN "P/N"
	1    1200 4250
	1    0    0    -1  
$EndComp
$Comp
L R R15
U 1 1 59084F04
P 1400 4250
F 0 "R15" V 1480 4250 40  0000 C CNN
F 1 "4k7" V 1407 4251 40  0000 C CNN
F 2 "SM0603" V 1330 4250 30  0001 C CNN
F 3 "" H 1400 4250 30  0001 C CNN
F 4 "Panasonic" H 1400 4250 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ472V" H 1400 4250 60  0001 C CNN "P/N"
	1    1400 4250
	1    0    0    -1  
$EndComp
$Comp
L R R1
U 1 1 59085172
P 2450 5900
F 0 "R1" V 2550 6000 40  0000 C CNN
F 1 "100k" V 2457 5901 40  0000 C CNN
F 2 "SM0603" V 2380 5900 30  0001 C CNN
F 3 "" H 2450 5900 30  0001 C CNN
F 4 "Panasonic" H 2450 5900 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ104V" H 2450 5900 60  0001 C CNN "P/N"
	1    2450 5900
	-1   0    0    1   
$EndComp
$Comp
L R R2
U 1 1 5908517A
P 4800 5950
F 0 "R2" V 4900 6050 40  0000 C CNN
F 1 "100k" V 4807 5951 40  0000 C CNN
F 2 "SM0603" V 4730 5950 30  0001 C CNN
F 3 "" H 4800 5950 30  0001 C CNN
F 4 "Panasonic" H 4800 5950 60  0001 C CNN "Manufacturer"
F 5 "ERJ-3GEYJ104V" H 4800 5950 60  0001 C CNN "P/N"
	1    4800 5950
	0    -1   -1   0   
$EndComp
$Comp
L R R7
U 1 1 59085244
P 6150 3600
F 0 "R7" V 6250 3700 40  0000 C CNN
F 1 "1k2" V 6157 3601 40  0000 C CNN
F 2 "SM0805" V 6080 3600 30  0001 C CNN
F 3 "" H 6150 3600 30  0001 C CNN
F 4 "Panasonic" H 6150 3600 60  0001 C CNN "Manufacturer"
F 5 "ERJ-6ENF1201V" H 6150 3600 60  0001 C CNN "P/N"
	1    6150 3600
	-1   0    0    -1  
$EndComp
Wire Wire Line
	4400 6150 4550 6150
Wire Wire Line
	4400 6050 4450 6050
Wire Wire Line
	4450 6050 4450 5950
Wire Wire Line
	4450 5950 4550 5950
Wire Wire Line
	5100 6250 4400 6250
Wire Wire Line
	5100 5950 5100 6300
Wire Wire Line
	5050 6150 6000 6150
Wire Wire Line
	5100 5950 5050 5950
Connection ~ 5100 6150
$Comp
L GND #PWR038
U 1 1 59099EA8
P 5100 7500
F 0 "#PWR038" H 5100 7500 30  0001 C CNN
F 1 "GND" H 5100 7430 30  0001 C CNN
F 2 "" H 5100 7500 60  0000 C CNN
F 3 "" H 5100 7500 60  0000 C CNN
	1    5100 7500
	1    0    0    -1  
$EndComp
Wire Wire Line
	5100 7500 5100 7400
Wire Wire Line
	5100 6800 5100 6900
Connection ~ 5100 6250
Wire Wire Line
	5100 6850 4450 6850
Wire Wire Line
	4450 6850 4450 6350
Wire Wire Line
	4450 6350 4400 6350
Connection ~ 5100 6850
Wire Wire Line
	5450 6150 5450 6650
Wire Wire Line
	5450 7500 5450 7050
Wire Wire Line
	5800 6950 5800 6800
Wire Wire Line
	5800 7350 5800 7500
Wire Wire Line
	5800 6150 5800 6300
Connection ~ 5450 6150
Connection ~ 5800 6150
Wire Wire Line
	6650 6050 6650 6150
Wire Wire Line
	6650 6150 6400 6150
Wire Wire Line
	5450 5850 5450 5650
Wire Wire Line
	5450 5650 5600 5650
Wire Wire Line
	6000 5650 6200 5650
Wire Wire Line
	6200 5450 6200 5850
Connection ~ 6200 5650
Wire Wire Line
	6200 4850 6200 4950
Wire Wire Line
	2450 5450 2450 5650
Wire Wire Line
	2450 5600 2650 5600
Connection ~ 2450 5600
Wire Wire Line
	3050 5600 3150 5600
Wire Wire Line
	3150 5600 3150 5700
Wire Wire Line
	2700 6150 2550 6150
Wire Wire Line
	2550 6150 2550 5600
Connection ~ 2550 5600
Wire Wire Line
	2700 6050 2650 6050
Wire Wire Line
	2650 6050 2650 7100
Wire Wire Line
	2700 6350 2650 6350
Connection ~ 2650 6350
Wire Wire Line
	2250 6250 2700 6250
Wire Wire Line
	2450 6250 2450 6150
$Comp
L GND #PWR039
U 1 1 5909B4BF
P 2650 7100
F 0 "#PWR039" H 2650 7100 30  0001 C CNN
F 1 "GND" H 2650 7030 30  0001 C CNN
F 2 "~" H 2650 7100 60  0000 C CNN
F 3 "~" H 2650 7100 60  0000 C CNN
	1    2650 7100
	1    0    0    -1  
$EndComp
Connection ~ 2450 6250
Wire Wire Line
	2250 7100 2250 7000
Wire Wire Line
	1450 6150 1450 6450
Text Notes 3150 4600 1    60   ~ 0
Divider ratio=2\n
Wire Wire Line
	7750 1800 7750 1900
Wire Wire Line
	7750 1900 7800 1900
Wire Wire Line
	7700 1900 7700 1850
Wire Wire Line
	7700 1850 7800 1850
Wire Wire Line
	7800 1850 7800 1800
Connection ~ 7700 1600
$EndSCHEMATC
